	.6502
	.LIST
****
*
* EQUATES FILE
*
* DUNGEON 2600 PROGRAM
*
* WRITTEN BY ADAM CLAYTON
* DEVELOPED BY SCULPTURED SOFTWARE
* COPYRIGHT 1987 ATARI
* 
*
*
* EQUATES
*
* I/O ADDRESSES
*
VSYNC	=	$00
VBLANK	=	$01
WSYNC	=	$02
RSYNC	=	$03
NUSIZ0	=	$04
NUSIZ1	=	$05
COLUP0	=	$06
COLUP1	=	$07
COLUPF	=	$08
COLUBK	=	$09
CTRLPF	=	$0A
REFP0	=	$0B
REFP1	=	$0C
PF0	=	$0D
PF1	=	$0E
PF2	=	$0F
RESP0	=	$10
RESP1	=	$11
RESBL	=	$14
AUDC0	=	$15
AUDF0	=	$17
AUDV0	=	$19
GRP0	=	$1B
GRP1	=	$1C
ENABL	=	$1F
HMP0	=	$20
HMP1	=	$21
HMBL	=	$24
VDELP0	=	$25
VDELP1	=	$26
VDELBL	=	$27
HMOVE	=	$2A
HMCLR	=	$2B
CXCLR	=	$2C
* INPUTS USED
CXBLPF	=	$06
SWCHA	=	$280
SWCHB	=	$282
SWACNT	=	$281
INTIM	=	$284
TIM64T	=	$296
****
*
* ZERO PAGE RAM ADDRESSES
*
****
	ORG    $80
*
* KERNAL LOCATIONS (CAN BE OVERWRITTEN BEFORE KERNAL BANK IS RUN) 16 BYTES
*
VOFFP0: DS.B	1		;VERTICAL OFFSET PLAYER 0
VOFFP1: DS.B	1
WIDP0:	DS.B	1		;LENGTH OF PLAYERS COUNTER
WIDP1:	DS.B	1
ADDRP0: DS.B	2		;ADDRESS OF PLAYER 0
ADDRP1: DS.B	2
COLP0:	DS.B	2		;COLOR ADDRESS
COLP1:	DS.B	2
PCOUNT: DS.B	1		;PLAYER RESET COUNTER
PFCNT:	DS.B	1		;PLAYFIELD UPDATE COUNTER
LCOUNT: DS.B	1		;LINE COUNTER
VCOUNT: DS.B	1		;LINES TILL PLAYFIELD DRAW
V1CNT:	DS.B	1		;LINES TILL PLAYER RESET
*
* KERNAL LOCATIONS (CAN BE OVERWRITTEN BY OTHER PROGRAMS BEFORE
*  UPLAY IS CALLED) 54 BYTES
*
VERTP0: DS.B	6		;VERTICAL OFFSET PLAYER
VERTP1: DS.B	6
HORIP0: DS.B	6		;HORIZONTAL LOCATIONS
HORIP1: DS.B	6
PLREF0: DS.B	6		;PLAYER REFLECT AND SIZE
PLREF1: DS.B	6
PTYPE0: DS.B	6		;PLAYER TYPE
PTYPE1: DS.B	6
LTYPE:	DS.B	6		;LINE TYPE 0=P1 RES 1=P0 RES FF=BOTH 2=NONE
*
* GENERAL LOCATAIONS 16 BYTES
*
FRMCNT: DS.B	1		;FRAME COUNTER
COLOR:	DS.B	2		;COLOR OF PF AND BK
HEALTH: DS.B	2		;HEALTH OF PLAYERS
SCORLO: DS.B	3		;SCORE OF PLAYERS IN BCD + HIGH SCORE
SCORHI: DS.B	3
CONTRL: DS.B	1		;CONTROL BYTE OF MODE, PAUSE BIT, BUTTON DOWN
PLAY:	DS.B	1		;GAME SELECTION
ROOM:	DS.B	1		;CURRENT ROOM NUMBER
LEVEL:	DS.B	1		;LEVEL NUMBER
KEYS:	DS.B	2		;KEYS OF PLAYERS
IT:	DS.B	1		;PLAYER WHO IS "IT" 0-1
*
* LOGIC BANK LOCATIONS 12 BYTES
*
WINDOW: DS.B	1		;LOCATION OF SCREEN WINDOW
MOTION: DS.B	1		;COUNTERS FOR WHICH PLAYERS TO DRAW
FRAME:	DS.B	1		;FRAME TO DO 0-2
HMBALL: DS.B	3		;BALL HORIZONTAL LOCATIONS
BALCNT: DS.B	3		;BALL VERTICAL LOCATIONS
ADIR:	DS.B	2		;BALL DIRECTIONS
RANDOM: DS.B	1		;RANDOM NUMBER
*
* UPLAY AND SETPLAY LOCATIONS 13 BYTES
*
TOTLIN: DS.B	7		;TABLE FOR PLAYERS IN LINE
CURLIN: DS.B	6		;CURRENT PLAYER IN LINE 
*
* TEMPARARY LOCATIONS USED BY ALL 6 BYTES
*
TEMP:	DS.B	6		;TEMPARARY LOCATIONS
*
* MAZE BANK LOCATIONS THAT OVERLAP KERNAL LOCATIONS
*
	ORG	$80
ADPF0:	DS.B	2		;ADDRESS OF PLAYFIELD (ADDR),Y
ADPF1:	DS.B	2		;USED IN MAZE BANK
ADPF2:	DS.B	2
*
* LOGIC BANK LOCATIONS THAT OVERLAP KERNAL LOCATIONS
*
	ORG	$80
NEWDIR: DS.B	1		;TEMP LOCATIONS FOR COLLISION DETECTION
NEWX:	DS.B	1
NEWX1:	DS.B	1
NEWY:	DS.B	1
NEWY1:	DS.B	1
VTEMP:	DS.B	2
*
* TITLE BANK LOCATIONS THAT OVERLAP KERNAL LOCATIONS
*
	ORG	$80
ADIG1:	 DS.B	 2		 ;LOCATIONS USED IN SIX WIDE
ADIG2:	 DS.B	 2		 ;FOR ENTERING LEVEL AND GAME OVER
ADIG3:	 DS.B	 2
ADIG4:	 DS.B	 2
ADIG5:	 DS.B	 2
ADIG6:	 DS.B	 2
****
*
* RAM LOCATIONS USED IN TITLE BANK (TITLE & SCORE)
*
****
	ORG	$80
LOW:	DS.B	64		;MEMORY FOR SCORE PROGRAM
BEAR:	DS.B	2
PLAYER: DS.B	2
COUNTER:
	DS.B	1
COUNTER1:
	DS.B	1
FCOUNT: DS.B	1
SKEY:	DS.B	2
	ORG    $F000
SARA	=	$80		;OFFSET FOR READ IN SARA RAM
****
*
* SARA RAM LOCATIONS
*
****
SOUND0: DS.B	2		;SOUND POINTERS
OBSTAT: DS.B	3		;OBJECT STATUS, BEGINNING ROOM NUMBER
PLYTAB: DS.B	10		;PLAYER NUMBERS 
PLHOR:	DS.B	10		;PLAYER HORIZONTAL LOCATIONS
PLVER:	DS.B	10		;PLAYER VERTICAL LOCATIONS
PLTYP:	DS.B	10		;PLAYER IMAGE
PLREF:	DS.B	10		;PLAYER REF, OLD DIR AND SHOTS
PLDIR:	DS.B	10		;PLAYER DIRECTION
RAMPF0: DS.B	21		;RAM PLAYFIELD LOCATIONS
RAMPF1: DS.B	21
RAMPF2: DS.B	21 

